/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: COpenFileDialog.cpp,v 1.3 1999/12/17 02:08:57 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CPath.h"
#include "COpenFileDialog.h"
#include "CWindow.h"

_USING_PGP

// Class COpenFileDialog member functions

void 
COpenFileDialog::Choose(
	HWND		parentWnd, 
	CPath&		path, 
	const char	*defaultPath, 
	const char	*title, 
	const char	*filter, 
	const char	*defaultExt)
{
	path.Empty();

	CPath	dir;

	if (IsntNull(defaultPath))
	{
		CPath	cDefaultPath(defaultPath);

		cDefaultPath.GetDirPart(dir);
		cDefaultPath.GetFileNamePart(path);
	}

	try
	{
		pgpClearMemory(&mOfn, sizeof(mOfn));

		// BUGBUG! Specifiy OFN_NOCHANGEDIR or Windows will leak a handle
		// to the last browsed-to directory, preventing PGPdisk unmount.

		mOfn.lStructSize		= sizeof(mOfn);
		mOfn.hwndOwner			= parentWnd;
		mOfn.lpstrFilter		= filter;
		mOfn.lpstrFile			= path.GetBuffer(
			PFLConstants::kMaxPathLength);
		mOfn.nMaxFile			= PFLConstants::kMaxPathLength;
		mOfn.lpstrInitialDir	= dir;
		mOfn.lpstrTitle			= title;
		mOfn.Flags				= OFN_EXPLORER | OFN_FILEMUSTEXIST | 
			OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_ENABLEHOOK;
		mOfn.lpstrDefExt		= defaultExt;
		mOfn.lpfnHook			= OpenDialogHookProc;
		mOfn.lCustData			= reinterpret_cast<long>(this);

		if (!GetOpenFileName(&mOfn))
		{
			CComboError	error;
			error.err = CommDlgExtendedError();

			if (!error.HaveNonPGPError())
				THROW_PGPERROR(kPGPError_UserAbort);
			else
				THROW_ERRORS(kPGPError_Win32WindowOpFailed, error.err);
		}

		path.ReleaseBuffer();
	}
	catch (CComboError&)
	{
		path.ReleaseBuffer();
		throw;
	}
}

UINT 
CALLBACK 
COpenFileDialog::OpenDialogHookProc(
	HWND	hdlg, 
	UINT	uiMsg, 
	WPARAM	wParam, 
	LPARAM	lParam)
{
	if (uiMsg == WM_NOTIFY)
	{
		LPNMHDR	pNM	= reinterpret_cast<LPNMHDR>(lParam);

		if (pNM->code == CDN_INITDONE)
		{
			CWindow	childDlg(hdlg);
			CWindow	parentDlg(childDlg.GetParent());

			parentDlg.Center();
		}
	}

	return 0;
}
